<?php

/*

	--------------------------------------------
	---------   Looking to make edits?   -------
	--------------------------------------------
	
	You can edit your template without editing this file directly.
	
	For more information about editing your template please refer to our full documentation below:
	
	https://www.zomex.com/docs/whmcs-templates/
	
	Feel free to contact Zomex if you run into any issues or have any questions.
	
	--------------------------------------------
	
*/

include "configuration_template.php";

$template_pagetitle = $template_name . "_whychooseus_name";
$template_pageurl = $whychooseus_page;
$template_pagetpl = $whychooseus_tpl;





use WHMCS\Authentication\CurrentUser;
use WHMCS\ClientArea;
use WHMCS\Database\Capsule;

define('CLIENTAREA', true);

require __DIR__ . '/init.php';

$ca = new ClientArea();

$ca->setPageTitle($whmcs->get_lang($template_pagetitle));

$ca->addToBreadCrumb('index.php', Lang::trans('globalsystemname'));
$ca->addToBreadCrumb($template_pageurl, $whmcs->get_lang($template_pagetitle));

$ca->initPage();

$currentUser = new CurrentUser();
$authUser = $currentUser->user();

// Check login status
if ($authUser) {

    $ca->assign('userFullname', $authUser->fullName);


    $selectedClient = $currentUser->client();
    if ($selectedClient) {

        $ca->assign(
            'clientInvoiceCount',
            $selectedClient->invoices()->count()
        );
    }

} else {

    $ca->assign('userFullname', 'Guest');

}

$ca->setTemplate($template_pagetpl);

$ca->output();